# Localization, Part 1

In this unit, you'll be localizing an Android app for another locale
-- France. However, first you must create (or obtain) a working
Android app to localize.

Your instructor will provide you with a simple flashcard app about US
road signs.  available to you. When you click the **RANDOM** button,
this flashcard app will present one of four road signs with a brief
description in English

![The opening screen of the Road Signs app](pix/screenshots/main_en1.png){#id .class width=180 height=320}

![A random US road sign card](pix/screenshots/yield_en2.png){#id .class width=180 height=320}

Each sign's description is in English, and it describes a US road
sign. This will change in Part 2, when we enable the app to describe
French signs for US tourists and US signs for French tourists.

## Exercising the Road Signs app

Run the Road Signs app in the Android Studio emulator or on your
personal device. Click the **RANDOM** button on each card to display a
new card with a random US road sign and a description of it in
English.

Although you will have a copy of the Road Signs app, it's recommended
that you also work through the Google Kotlin tutorial for Android.
Road Signs is based on the Google tutorial, and the tutorial will help
you understand how it is coded. In addition, you might learn the new
language Kotlin, which is an official programming language for Android
along with Java and C++. Road Signs is programmed in Kotlin, but
Kotlin is highly compatible with Java, so if you want to code your app
in Java instead, you can do so.

### References
* [Build Your First Android App in Kotlin](https://codelabs.developers.google.com/codelabs/build-your-first-android-app-kotlin/index.html#0)
* [how to display random xml layouts in android - Stack Overflow](https://stackoverflow.com/questions/17169284/how-to-display-random-xml-layouts-in-android)
* [Road signs in the United States - Wikipedia](https://en.wikipedia.org/wiki/Road_signs_in_the_United_States)

## Possible issues

Android Studio is constantly in development, so you might encounter
some errors that are difficult to understand. Fortunately, there is a
thriving Android developer community online that has already found the
solutions for some of these issues. See the References section below
for some of these issues and solutions.

### References

* [“Not enough information to infer parameter T” with Kotlin and Android](https://stackoverflow.com/questions/45267041/not-enough-information-to-infer-parameter-t-with-kotlin-and-android)
* [Outdated Kotlin Runtime](https://stackoverflow.com/questions/45397925/outdated-kotlin-runtime)
* [Automatic library version update for Gradle projects is currently unsupported. Please update your build.gradle manually](https://stackoverflow.com/questions/44574740/automatic-library-version-update-for-gradle-projects-is-currently-unsupported-p)
* [gradle - Why won't Android Studio find my resources?](https://stackoverflow.com/questions/16858086/why-wont-android-studio-find-my-resources)
* [Split lib_main was defined multiple times](https://stackoverflow.com/questions/34803518/split-lib-main-was-defined-multiple-times)
